#include <Carbon.h>
#define ITMAX 10000
/*
   	Fractale Mandel	 v 1.0 X  08/05/02

Fait avec CodeWarrior 7 (CodeWarrior IDE v4.2.5)

Ce programme fonctionne sur MacOS X
Configuration minimum : MacOS 8.6 avec CarbonLib 1.4

  2002 All Rights Reserved to Didier STRAUS

		http://www.Software-DS.com
*/

WindowRef 	gMainWindow;
WindowPtr	theWindow;
Boolean		gSystemIsMacOSX;
	
void main (void) {
	int i,j,it,largeur=400,hauteur=300,xmin=0,xmax=400,ymin=0,ymax=300;
	double d;
	double cr,ci;
	double zr,zi;
	double zr_1,zi_1;
	const double rmin= -2.,rmax= 1.,imin= -1.,imax= 1.;
	RGBColor theColour;

	InitCursor();
	if (!(theWindow = GetNewCWindow(300,NULL,(WindowPtr)-1))){
		SysBeep(5);
		ExitToShell();
	}
	SetPortWindowPort(theWindow);
	PenSize(1,1);
	
	if (gSystemIsMacOSX==true)
        ShowSheetWindow(theWindow, gMainWindow);
	else
		ShowWindow(theWindow);

	for(j=ymin;j<ymax;j++){
		for(i=xmin;i<xmax;i++){
			cr= (double)i/(double)largeur*(rmax-rmin)+rmin;
			ci= (double)j/(double)hauteur*(imax-imin)+imin;
			d= 0.;
			zr_1= 0.;
			zi_1= 0.;
			
			for(it=0;it<ITMAX&&d<4.;it++){
				zr=zr_1*zr_1-zi_1*zi_1;
				zi=2.*zr_1*zi_1;
				zr+=cr;
				zi+=ci;
				d=zr*zr+zi*zi;
				zr_1=zr;
				zi_1=zi;
			}
			/* choix de la couleur */
			if(d<4.) {
				/* le pixel (i,j) fait parti de l'ensemble noir */
				ForeColor(blackColor);
				MoveTo(i,j);
				LineTo(i,j);
			}
			else{
				/* le pixel (i,j) fait parti de l'ensemble degrade de couleur */
				/* le degrade doit etre en fonction du nombre d'iterations (it) */
				if (it<6)
					ForeColor(greenColor);
				else if (it<15) {
					theColour.red   = 15000;
					theColour.green = 5000;
					theColour.blue  = 60000-(it-6)*6000;
					RGBForeColor(&theColour);
				}
				else if (it<30) {
					theColour.blue  = 10000;
					RGBForeColor(&theColour);
				}
				else 
					ForeColor(blueColor);
				
				MoveTo(i,j);
				LineTo(i,j);
			}
		}
		QDFlushPortBuffer(GetWindowPort(FrontWindow()),NULL);
	}

	while (!Button()){}; /* Pause: Attente d'un clic de souris. */
	while (Button()){};
/* 2002 All Rights Reserved to Didier STRAUS  www.Software-DS.com  Software_DS@mac.com */
}
